

raintimes = {...
	[2016,04,26,23,17,00], [2016,04,27,03,30,00];...
	[2016,04,29,12,40,00], [2016,04,29,14,31,00];...
	[2016,04,29,18,20,00], [2016,04,29,19,14,00];...
	[2016,05,10,00,47,00], [2016,05,10,01,32,00];...
	[2016,05,13,22,49,00], [2016,05,14,00,31,00];...
	[2016,05,16,06,25,00], [2016,05,16,09,03,00];...
	[2016,05,16,15,17,00], [2016,05,16,16,52,00];...
	[2016,05,17,04,13,00], [2016,05,17,07,02,00]};

if ~exist('rain_rate','var')
	[rain_time, rain_rate, total_drops, drop_diameter, num_drops, mean_dropdiameter, rain_amount,median_dropdiameter, drops_time, fall_speed] = VideoDisdromeder_Import();
	rain_rate(rain_rate==0) = NaN;
	total_drops(total_drops==0) = NaN;
	mean_dropdiameter(mean_dropdiameter==0) = NaN;
end

if ~exist('avgangrb');
	AAE_QualityControl();
end


% figure; plot(drops_time,fall_speed);

for r = 1:length(raintimes)
	%% Average AAE At Rain Start
	[~,curr_rainstartidx_PSAP] = min(abs(datenum(avgPSAPtime) - datenum(raintimes{r,1})));
	[~,curr_rainendidx_PSAP] = min(abs(datenum(avgPSAPtime) - datenum(raintimes{r,2})));
	
	[rainstart_val,curr_rainstartidx_rain] = min(abs(datenum(rain_time) - datenum(raintimes{r,1})));
	[rainend_val,curr_rainendidx_rain] = min(abs(datenum(rain_time) - datenum(raintimes{r,2})));
	
	[~,curr_rainstartidx_fallspeed] = min(abs(datenum(drops_time) - datenum(raintimes{r,1})));
	[~,curr_rainendidx_fallspeed] = min(abs(datenum(drops_time) - datenum(raintimes{r,2})));
	
% 	vline(drops_time(curr_rainstartidx_fallspeed));
% 	vline(drops_time(curr_rainendidx_fallspeed));
	
	AAE_raintable(r,1) = avgangrb(curr_rainstartidx_PSAP);
	AAE_raintable(r,2) = avgangrb(curr_rainendidx_PSAP);
	
	AAE_increase(r,1) = AAE_raintable(r,2) - AAE_raintable(r,1);
	
	avg_rain_rate(r,1) = nanmean(rain_rate(curr_rainstartidx_rain:curr_rainendidx_rain));
	avg_dropdiameter(r,1) = nanmean(mean_dropdiameter(curr_rainstartidx_rain:curr_rainendidx_rain));
	avg_totaldrops(r,1) = nansum(total_drops(curr_rainstartidx_rain:curr_rainendidx_rain));
	avg_mediandrop(r,1) = nanmean(median_dropdiameter(curr_rainstartidx_rain:curr_rainendidx_rain));
	
	avg_fallspeed(r,1) = nanmean(fall_speed(curr_rainstartidx_fallspeed:curr_rainendidx_fallspeed));
	
	rain_duration(r,1) = (datenum(raintimes{r,2}) - datenum(raintimes{r,1})).*24.*60;
	
	We(r,1) = (1000 .* avg_fallspeed(r,1).^2 .* avg_dropdiameter(r,1)./1000) ./ 0.072; %
	
	err_ang_table(r,1) = err_ang(curr_rainstartidx_PSAP);
	err_ang_table(r,2) = err_ang(curr_rainendidx_PSAP);
	
	AAE_increase_err(r,1) = sqrt(err_ang_table(r,1).^2 + err_ang_table(r,2).^2);
	
	
end

marksize = 30;

figh = figure;
% maxfig(gcf,1);
set(figh,'Units','normalized','Position',[0.01,0.05,0.67,0.87]);
hax2 = tight_subplot(2,3,[0.1,0.01],[0.07,0.02],[0.06,0.02]);
axes(hax2(1)); plot(avg_rain_rate,AAE_increase,'Marker','.','MarkerSize',marksize,'LineStyle','none'); xlabel('Rain Rate (mm/hr)'); ylabel('\DeltaAAE');
axes(hax2(2)); plot(avg_dropdiameter,AAE_increase,'Marker','.','MarkerSize',marksize,'LineStyle','none'); xlabel('Mean Drop Dia. (mm)');
axes(hax2(3)); plot(avg_totaldrops,AAE_increase,'Marker','.','MarkerSize',marksize,'LineStyle','none'); xlabel('Total Drops');
axes(hax2(4)); plot(rain_duration,AAE_increase,'Marker','.','MarkerSize',marksize,'LineStyle','none'); xlabel('Rain Duration (min)'); ylabel('\DeltaAAE');
axes(hax2(5)); plot(We,AAE_increase,'Marker','.','MarkerSize',marksize,'LineStyle','none'); xlabel('Weber Number'); set(gca,'XScale','log');
axes(hax2(6)); plot(avg_fallspeed,AAE_increase,'Marker','.','MarkerSize',marksize,'LineStyle','none'); xlabel('Fall Speed (m/s)');

set(hax2(:),'FontWeight','bold','FontSize',15,'YLim',[-0.5,0.5],'LineWidth',2,'Color','none');
set(hax2([1,4]),'YTick',[-0.4,-0.2,0,0.2,0.4]);
set(hax2([2,3,5,6]),'YTick',[]);
set(hax2(1),'XLim',[0,16],'XTick',[0,5,10,15]);
set(hax2(2),'XTick',[0.6,0.8,1,1.2],'XLim',[0.5,1.3]);
set(hax2(3),'XScale','log','XTick',[10.^4,10.^5,10.^6],'XLim',[2.*10.^3,2.*10.^6]);
set(hax2(4),'XTick',[0,60,120,180,240]);
set(hax2(5),'XLim',[9,1100],'XTick',[10.^1,10.^2,10.^3]);
set(hax2(6),'XLim',[1.5,5.5],'XTick',[2,3,4,5]);




